#!/bin/bash

# Use only with kernel 2.6
# Load the APCI-1516 and create the device node 
# under /dev/apci1516 and the minor number of the board.

DRIVER_NAME="apci1516"
BOARD_NAME="apci1516"
MODULE_NAME="/lib/modules/2.6.34.10/kernel/drivers/addi-data/$BOARD_NAME.ko"
VENDOR_DEVICE_ID="15b81001"
NBOARDS=1


insmod $MODULE_NAME

# Search the major number
MAJOR=$(grep $DRIVER_NAME /proc/devices | cut -f 1 -d\ )

mkdir -p "/dev/$BOARD_NAME"
cd "/dev/$BOARD_NAME"

# Create nodes
i=0
while [ $i -lt $NBOARDS ]; do

	if [ -a "/dev/$BOARD_NAME/$i" ]; then
		rm "/dev/$BOARD_NAME/$i"
	fi

	mknod $i c $MAJOR $i
	chmod 666 /dev/$BOARD_NAME/$i	
	echo "Make node /dev/$BOARD_NAME/$i"

	i=$((i+1))
done

exit 0





